Imports System
Imports System.Reflection

'
' This class is an example of a virtual proxy.
'
Public Class CabinetAssistantProxy
    Private assistant As ICabinetAssistant = Nothing
    Private myParam As String ' for assistant object's constructor

    '
    ' Constructor
    '
    Public Sub New(ByVal s As String)
        myParam = s
    End Sub

    '
    ' Get the the CabinetAssistant object that is used to implement
    ' operations.  This method creates it if it did not exist.
    '
    ReadOnly Property CabinetAssistant() As ICabinetAssistant
        Get
            If assistant Is Nothing Then
                Try
                    ' get the type handle
                    Dim t As Type = Type.GetType("CabinetAssistant")
                    ' build the parameter types of the constructor we want
                    Dim types() As Type = {GetType(String)}
                    ' get the info handle for the constructor
                    Dim ci As ConstructorInfo = t.GetConstructor(BindingFlags.Instance Or BindingFlags.Public, Nothing, types, Nothing)
                    ' create the array of objects for the constructor parameters
                    Dim p() As Object = {myParam}
                    ' get the virtual instance for this type
                    assistant = CType(ci.Invoke(p), ICabinetAssistant)
                Catch
                End Try
                If assistant Is Nothing Then
                    ' deal with failure to create CabinetAssistant object
                    Throw New ApplicationException()
                End If
            End If
            Return assistant
        End Get
    End Property

    Public Sub Operation1()
        CabinetAssistant.Operation1()
    End Sub 'Operation1

    Public Sub Operation2()
        CabinetAssistant.Operation2()
    End Sub 'Operation2

End Class 'CabinetAssistantProxy
